<?php

declare(strict_types=1);

class Logger
{
    private static ?string $path = null;

    public static function log(string $level, string $message): void
    {
        $path = self::getPath();
        $entry = sprintf("[%s] [%s] %s\n", (new DateTimeImmutable())->format(DateTime::ATOM), strtoupper($level), $message);
        @mkdir(dirname($path), 0777, true);
        file_put_contents($path, $entry, FILE_APPEND | LOCK_EX);
    }

    private static function getPath(): string
    {
        return self::$path ??= __DIR__ . '/../logs/blog_engine.log';
    }
}
